/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.explorer.internal.handlers;

import com.aptana.core.util.CollectionsUtil;
import com.aptana.explorer.internal.ui.CaseInsensitiveProjectComparator;
import com.aptana.explorer.internal.ui.SingleProjectView;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.eclipse.ui.menus.IWorkbenchContribution;
import org.eclipse.ui.services.IEvaluationService;
import org.eclipse.ui.services.IServiceLocator;

public class SwitchProjectMenuItem
extends CompoundContributionItem
implements IWorkbenchContribution {
    private IServiceLocator serviceLocator;

    protected IContributionItem[] getContributionItems() {
        ArrayList<1> contributions = new ArrayList<1>();
        IEvaluationService evalService = (IEvaluationService)this.serviceLocator.getService(IEvaluationService.class);
        IEvaluationContext context = evalService.getCurrentState();
        Object part = context.getVariable("activePart");
        if (part instanceof SingleProjectView) {
            final SingleProjectView view = (SingleProjectView)((Object)part);
            IProject viewProject = view.getActiveProject();
            Object[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            List sortedProjects = CollectionsUtil.newList((Object[])projects);
            Collections.sort(sortedProjects, new CaseInsensitiveProjectComparator());
            for (final IProject project : sortedProjects) {
                if (!project.isAccessible() || project.equals((Object)viewProject)) continue;
                contributions.add(new ContributionItem(){

                    public void fill(Menu menu, int index) {
                        MenuItem item = new MenuItem(menu, 0);
                        item.setText(project.getName());
                        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent e) {
                                view.setActiveProject(project);
                            }
                        });
                    }
                });
            }
        }
        return contributions.toArray(new IContributionItem[contributions.size()]);
    }

    public void initialize(IServiceLocator serviceLocator) {
        this.serviceLocator = serviceLocator;
    }
}

